<%@page import="org.springframework.context.i18n.LocaleContextHolder"%>
<%@include file="/WEB-INF/includeTemplate.inc"%>
<%@ taglib prefix="spring" uri="/WEB-INF/tld/spring.tld"%>
<%@ taglib uri="/WEB-INF/tld/tiles-jsp.tld" prefix="tiles"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<c:set var="idiomaNavegacion"><%=LocaleContextHolder.getLocale().getLanguage() %></c:set>
	<!-- Inicio Documentacion Section -->
    <section id="documentacion">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <h3 class="section-heading"><spring:message code="menu.recomendaciones"/></h3>
                    <h3 class="section-subheading text-muted"><spring:message code="descripcion.recomendaciones"/></h3>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <ul class="timeline">
                    	 <li>
                            <div class="timeline-image">
                                <img class="img-circle img-responsive" src="${staticsUrl}/aa94a/images/ayuda.png" alt="">
                            </div>
                            <div class="timeline-panel">
                                <div class="timeline-heading">
                                    <h4><spring:message code="titulo.fecha3"/></h4>
                                    <h4 class="subheading"><spring:message code="titulo.descripcion3"/></h4>
                                </div>
                                <div class="timeline-body">
                                    <p class="text-muted"><spring:message code="descripcion.fecha3"/></p>
									<p>
									<c:if test="${idiomaNavegacion == 'es'}">
									<a href="${staticsUrl}/aa94a/documentacion/es_manual_usuario.pdf" target="_blank" class="btn btn-primary btn-md boton formaBoton"><spring:message code="botondescargar"/></a>
									</c:if>
									<c:if test="${idiomaNavegacion == 'eu'}">
									<a href="${staticsUrl}/aa94a/documentacion/eu_manual_usuario.pdf" target="_blank" class="btn btn-primary btn-md boton formaBoton"><spring:message code="botondescargar"/></a>
									</c:if>
									</p>
                                </div>
                            </div>
                    	 </li>
						 <li class="timeline-inverted">
                            <div class="timeline-image">
                                <img class="img-circle img-responsive" src="${staticsUrl}/aa94a/images/triptico2.png" alt="">
                            </div>
                            <div class="timeline-panel">
                                <div class="timeline-heading">
                                    <h4><spring:message code="titulo.fecha1"/></h4>
                                    <h4 class="subheading"><spring:message code="titulo.descripcion1"/></h4>
                                </div>
                                <div class="timeline-body">
                                    <p class="text-muted"><spring:message code="descripcion.fecha1"/></p>
									<p>
									<c:if test="${idiomaNavegacion == 'es'}">
									<a href="${staticsUrl}/aa94a/documentacion/es_manual_recomendaciones_transporte_bobinas.pdf" target="_blank" class="btn btn-primary btn-md boton formaBoton"><spring:message code="botondescargar"/></a>
									</c:if>
									<c:if test="${idiomaNavegacion == 'eu'}">
									<a href="${staticsUrl}/aa94a/documentacion/eu_manual_recomendaciones_transporte_bobinas.pdf" target="_blank" class="btn btn-primary btn-md boton formaBoton"><spring:message code="botondescargar"/></a>
									</c:if>
									</p>
                                </div>
                            </div>
                        </li> 
						<li>
                            <div class="timeline-image">
                                <img class="img-circle img-responsive" src="${staticsUrl}/aa94a/images/triptico.jpg" alt="">
                            </div>
                            <div class="timeline-panel">
                                <div class="timeline-heading">
                                    <h4><spring:message code="titulo.fecha2"/></h4>
                                    <h4 class="subheading"><spring:message code="titulo.descripcion2"/></h4>
                                </div>
                                <div class="timeline-body">
                                    <p class="text-muted"><spring:message code="descripcion.fecha2"/></p>
									<p>
									<c:if test="${idiomaNavegacion == 'es'}">
									<a href="${staticsUrl}/aa94a/documentacion/es_triptico2016.pdf" target="_blank" class="btn btn-primary btn-md boton formaBoton"><spring:message code="botondescargar"/></a>
									</c:if>
									<c:if test="${idiomaNavegacion == 'eu'}">
									<a href="${staticsUrl}/aa94a/documentacion/eu_triptico2016.pdf" target="_blank" class="btn btn-primary btn-md boton formaBoton"><spring:message code="botondescargar"/></a>
									</c:if>									
									</p>
                                </div>
                            </div>
                        </li>
					</ul>
                </div>
            </div>
        </div>
    </section>
	<!-- Fin Documentacion Section -->